//
//  PRHOnOffButtonCell.h
//  PRHOnOffButton
//
//  Created by Peter Hosey on 2010-01-10.
//  Copyright 2010 Peter Hosey. All rights reserved.
//
//  Extended by Dain Kaplan on 2012-01-31.
//  Copyright 2012 Dain Kaplan. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
	slideSwitchControlDefaultColors = 0,
	slideSwitchControlCustomColors = 1,
	slideSwitchControlBlueGreyColors = 2,
	slideSwitchControlGreenRedColors = 3,
	slideSwitchControlBlueRedColors = 4
} slideSwitchControlColors;

NSRect DKCenterRect(NSRect smallRect, NSRect bigRect);

@interface slideSwitchControlCell : NSButtonCell {
	BOOL tracking;
	NSPoint initialTrackingPoint, trackingPoint;
	NSTimeInterval initialTrackingTime, trackingTime;
	NSRect trackingCellFrame; //Set by drawWithFrame: when tracking is true.
	CGFloat trackingThumbCenterX; //Set by drawWithFrame: when tracking is true.
	struct PRHOOBCStuffYouWouldNeedToIncludeCarbonHeadersFor *stuff;
	BOOL showsOnOffLabels;
	slideSwitchControlColors slideSwitchControlColors;
	NSColor *customOnColor;
	NSColor *customOffColor;
	NSString *onSwitchLabel;
	NSString *offSwitchLabel;
    NSFont  *font;
    
    NSColor *startingThumbColor;
    NSColor *endingThumbColor;
    double thumbSizePercentage;
    NSString *thumbOnLabel;
    NSString *thumbOffLabel;
    NSFont  *thumbLabelFont;
}

@property (readwrite, copy) NSString *onSwitchLabel;
@property (readwrite, copy) NSString *offSwitchLabel;
@property (readwrite, assign) BOOL showsOnOffLabels;
@property (readwrite, assign) slideSwitchControlColors slideSwitchControlColors;

@property (readwrite, copy) NSColor *startingThumbColor;
@property (readwrite, copy) NSColor *endingThumbColor;
@property (readwrite, assign) double thumbSizePercentage;
@property (readwrite, copy) NSString *thumbOnLabel;
@property (readwrite, copy) NSString *thumbOffLabel;
@property (readwrite, copy) NSFont *thumbLabelFont;

- (void) setslideSwitchCustomOnColor:(NSColor *)onColor offColor:(NSColor *)offColor;

@end
